<?php
	function noDescuentos($var){
		if($var['tienda'] == 126){
			preg_match_all('/^DESCUENTO.*/i', $var['nombre'], $matches, PREG_SET_ORDER, 0);
			return count($matches) == 0;
		}
		else
			return true;
	}

	$listas = getClienteListas($clienteId);
	$MONEDAS = getMonedasWeb($tiendaId, $listas[0]);
	$NUEVOS = array_filter(getProductosPorAtributo($tiendaId, 'nuevo', $tienda['cantListadoProductosNuevos'], $listas[0], $listas[1], isset($clienteId)), "noDescuentos");

?>
		<!-- NEW ARRIVALS -->
		<section class="new_arrivals padbot50 tovar_section">
			<!-- CONTAINER -->
			<div class="container">
				<h2><?php echo count($NUEVOS)>0? 'Nuevos Productos': ''; ?></h2>

				<!-- JCAROUSEL -->
				<div class="jcarousel-wrapper">

					<!-- NAVIGATION -->
					<div class="jCarousel_pagination">
						<a href="javascript:void(0);" class="jcarousel-control-prev" ><i class="fa fa-angle-left"></i></a>
						<a href="javascript:void(0);" class="jcarousel-control-next" ><i class="fa fa-angle-right"></i></a>
					</div><!-- //NAVIGATION -->

					<div class="jcarousel" data-appear-top-offset='-100' data-animated='fadeInUp'>
						<ul>
							<?php
							foreach ($NUEVOS as $PRODUCTO) {
								if ($PRODUCTO['imagen']==''){
									$imagenM = "/glammy/images/noimage.png";
								}else{
									$imagenM = "/itemDetails/". $tiendaId . "/" . $PRODUCTO['id'] . "/M." . $PRODUCTO['imagen'];
								}

								if($PRODUCTO[''])
							?>
							<li>
								<!-- TOVAR -->
								<div class="tovar_item_new">
									<div class="tovar_img">
										<img src="<?php echo $imagenM; ?>" alt="" />
										<div class="open-project-link"><a class="open-project tovar_view" href="javascript:void(0);" data-url="<?php echo 'productQuickView0.php?producto='.$PRODUCTO['id']; ?>">+ info</a></div>
									</div>
									<div class="tovar_description clearfix">
										<a class="tovar_title" href="<?php echo $PRODUCTO['url']==''? '?p=productPage&producto='.$PRODUCTO['id']: $PRODUCTO['url'].'.html'; ?>" ><?php echo $PRODUCTO['nombre']; ?></a>
										<?php if ($tienda['precio'] == 1 and $PRODUCTO['precio_venta'] != 0){ ?>
										<span class="tovar_item_small_price"><?php echo $MONEDAS[$PRODUCTO['id']]." ".$PRODUCTO['precio_venta']; ?></span>
										<?PHP }elseif( $tienda['precio'] == 1 and $PRODUCTO['precio'] != 0){ ?>
										<span class="tovar_item_small_price"><?php echo $MONEDAS[$PRODUCTO['id']]." ".$PRODUCTO['precio']; ?></span>
										<?PHP }elseif( $tienda['precio'] == 0 and isset($_SESSION['cliente.id']) and $PRODUCTO['precio'] != 0){ ?>
										<span class="tovar_item_small_price"><?php echo $MONEDAS[$PRODUCTO['id']]." ".$PRODUCTO['precio']; ?></span>
										<?PHP }else{ ?>
										<span class="tovar_item_small_price"><?php echo $PRODUCTO['codigo']; ?></span>
										<?php } ?>
									</div>
								</div><!-- //TOVAR -->
							</li>
							<?php } ?>
						</ul>
					</div>
				</div><!-- //JCAROUSEL -->
			</div><!-- //CONTAINER -->
		</section><!-- //NEW ARRIVALS -->
